<?xml version="1.0" encoding="utf-8" ?> 

<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform' xmlns:HTML='http://www.w3.org/Profiles/XHTML-transitional' xmlns:dt='urn:schemas-microsoft-com:datatypes'>

	<xsl:output method='html'/>



	<xsl:template match='@* | node()'>

		<xsl:copy><xsl:apply-templates select="@* | node()"/></xsl:copy>

	</xsl:template>

	

	<xsl:strip-space elements="*"/>



	<xsl:include href="../../apt/views/spreadsheetview.xslt"/>

	

	<xsl:template match='/'>

		<xsl:call-template name="spreadsheet_start">

			<xsl:with-param name="name">log</xsl:with-param>

			<xsl:with-param name="nohandler">true</xsl:with-param>

		</xsl:call-template>

	</xsl:template>



	<xsl:template name="spreadsheet_columns_def">

		<xsl:param name="sheet"/>

		<xsl:param name="hidden"/>

		<xsl:call-template name="spreadsheet_column">

			<xsl:with-param name="name">Catagory</xsl:with-param>

			<xsl:with-param name="width">80px</xsl:with-param>

			<xsl:with-param name="hidden" select="$hidden"/>

		</xsl:call-template>

		<xsl:call-template name="spreadsheet_column">

			<xsl:with-param name="name">Message</xsl:with-param>

			<xsl:with-param name="width">100%</xsl:with-param>

			<xsl:with-param name="hidden" select="$hidden"/>

		</xsl:call-template>

	</xsl:template>



	<xsl:template name="spreadsheet_rows_def">

		<xsl:param name="hidden"/>

		<xsl:param name="sheet"/>

		<xsl:for-each select="log/*">

			<xsl:call-template name="spreadsheet_row">

				<xsl:with-param name="hidden" select="$hidden"/>

				<xsl:with-param name="sheet" select="$sheet"/>

			</xsl:call-template>

		</xsl:for-each>

	</xsl:template>



	<xsl:template name="spreadsheet_values_def">

		<xsl:param name="sheet"/>

		<xsl:call-template name="spreadsheet_value">

			<xsl:with-param name="value" select='string(parent::*/@catagory)'/>

		</xsl:call-template>

		<xsl:call-template name="spreadsheet_value">

			<xsl:with-param name="value">

				<div class='log{name()}'><xsl:apply-templates/></div>

			</xsl:with-param>

		</xsl:call-template>

	</xsl:template>



	<xsl:template match='line'>

		<xsl:apply-templates/><br/>

	</xsl:template>



	<xsl:template match='source'>

		<bdo class='titoAnchor' onclick='Application.theApp.gotoSource("{@url}", "{@statId}");'><xsl:value-of select='@url'/><xsl:if test='@line'>,<xsl:value-of select='@line'/></xsl:if></bdo>

	</xsl:template>

</xsl:stylesheet>

